package etradeproject;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */

public class saveProfile extends HttpServlet {
    static final private String CONTENT_TYPE = "text/html; charset=windows-1251";
    //Initialize global variables
    public void init() throws ServletException
    {
    }

    private String getParameter(HttpServletRequest request, String name)
    {
      if(request.getParameter(name)==null || request.getParameter(name.trim()).equals(""))
        return null;

      return request.getParameter(name);
    }

    //Process the HTTP Get request
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
        request.setCharacterEncoding("windows-1251");
        response.setContentType(CONTENT_TYPE);
        User user = null;

        String firstName = getParameter(request, "firstName");
        String lastName = getParameter(request, "lastName");
        String city = getParameter(request, "city");
        String address = getParameter(request, "address");
        String email = getParameter(request, "email");
        String userName = getParameter(request, "userName");
        String password1 = getParameter(request, "password1");
        String password2 = getParameter(request, "password2");

        if(firstName==null || userName==null ||
           password1==null || password2==null ||
           !password1.equals(password2))
        {
          request.getSession().setAttribute("errorValue", "          !");

          response.sendRedirect("registration.jsp?error=true"
                                + (firstName!=null?"&firstName=" + firstName:"")
                                + (lastName!=null?"&lastName=" + lastName:"")
                                + (city!=null?"&city=" + city:"")
                                + (address!=null?"&address=" + address:"")
                                + (email!=null?"&email=" + email:"")
                                + (userName!=null?"&userName=" + userName:"")
                                );
          return;
        }

        try
        {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            Connection con = DriverManager.getConnection("jdbc:odbc:storeDB", "sa", "");

            // Some kind of transaction - transaction ends on con.commit() method.
            con.setAutoCommit(false);

            Statement stmt = con.createStatement();

            ResultSet rs = stmt.executeQuery("SELECT * FROM Users WHERE user_name = '" + userName + "'");

            if(rs.next())
            {
              con.commit();
              rs.close();
              stmt.close();
              con.close();

              request.getSession().setAttribute("errorValue", "      !   !");

              response.sendRedirect("registration.jsp?error=true"
                                    + (firstName!=null?"&firstName=" + firstName:"")
                                    + (lastName!=null?"&lastName=" + lastName:"")
                                    + (city!=null?"&city=" + city:"")
                                    + (address!=null?"&address=" + address:"")
                                    + (email!=null?"&email=" + email:"")
                                    + (userName!=null?"&userName=" + userName:"")
                                    );

              return;
            }

            /*
            Bad variant to insert
            stmt.executeUpdate("INSERT INTO Users(first_name, last_name, city, address, e_mail, user_name, password) " +
                               "VALUES('" + firstName + "', " +
                               (lastName==null?"null": "'" + lastName + "'") + ", " +
                               (city==null?"null": "'" + city + "'") + ", " +
                               (address==null?"null": "'" + address + "'") + ", " +
                               (email==null?"null": "'" + email + "'") + ", '" +
                               userName + "', '" + password1 + "')");
            */

            // Good variant to insert values
            PreparedStatement st = con.prepareStatement("INSERT INTO Users(first_name, last_name, city, address, e_mail, user_name, password) VALUES(?, ?, ?, ?, ?, ?, ?)");

            st.setObject(1, firstName, Types.VARCHAR);
            st.setObject(2, lastName, Types.VARCHAR);
            st.setObject(3, city, Types.VARCHAR);
            st.setObject(4, address, Types.VARCHAR);
            st.setObject(5, email, Types.VARCHAR);
            st.setObject(6, userName, Types.VARCHAR);
            st.setObject(7, password1, Types.VARCHAR);

            st.execute();
            st.close();
            con.commit(); // end of transaction

            rs = stmt.executeQuery("SELECT * FROM Users WHERE user_name = '" + userName + "'");

            if(!rs.next())
            {
              rs.close();
              stmt.close();
              con.close();

              request.getSession().setAttribute("errorValue", "  !       !");

              response.sendRedirect("registration.jsp?error=true"
                                    + (firstName!=null?"&firstName=" + firstName:"")
                                    + (lastName!=null?"&lastName=" + lastName:"")
                                    + (city!=null?"&city=" + city:"")
                                    + (address!=null?"&address=" + address:"")
                                    + (email!=null?"&email=" + email:"")
                                    + (userName!=null?"&userName=" + userName:"")
                                    );

              return;
            }

            user = new User(rs.getInt("user_id"), rs.getString("first_name"),
                            rs.getString("last_name"), rs.getString("city"),
                            rs.getString("address"), rs.getString("e_mail"),
                            rs.getString("user_name"), rs.getString("password"));

            request.getSession().setAttribute("user", user);

            rs.close();
            stmt.close();
            con.close();
        }
        catch (Exception ex) {
            request.getSession().setAttribute("errorValue", "  : " + ex.toString() + "!");
        }

        Cookie userCookie = new Cookie("userName", java.net.URLEncoder.encode(user.getUserName()));
        userCookie.setMaxAge(60*60*24*30); //time to  expire - 30 days
        response.addCookie(userCookie);

        request.getSession().setAttribute("basket", new Basket());

        response.sendRedirect("index.jsp");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
    {
      doGet(request, response);
    }
    //Clean up resources
    public void destroy() {
    }
}